/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler.reflective;

import jjtraveler.BottomUp;
import jjtraveler.Event;
import jjtraveler.Logger;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import jjtraveler.VisitorTestCase;
import jjtraveler.reflective.VisitableIdentity;
import jjtraveler.reflective.VisitableSequence;
import jjtraveler.reflective.VisitableVisitor;
import jjtraveler.reflective.WrapLog;
import jjtraveler.util.UtilTest;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WrapLogTest
extends VisitorTestCase {
    public void testWrapIdentity() throws VisitFailure {
        VisitableIdentity i = new VisitableIdentity();
        WrapLog w = new WrapLog(this.logger);
        VisitableVisitor v = w.visitVisitor(i);
        Visitable result = v.visit(this.n0);
        Logger expectedLogger = new Logger((Visitor)i, new Visitable[]{this.n0});
        WrapLogTest.assertEquals((Object)expectedLogger, (Object)this.logger);
        WrapLogTest.assertEquals((Object)this.n0, (Object)result);
    }

    public void testWeaveSequence() throws VisitFailure {
        VisitableIdentity i = new VisitableIdentity();
        VisitableSequence s = new VisitableSequence(i, i);
        WrapLog w = new WrapLog(this.logger);
        VisitableVisitor v = (VisitableVisitor)new BottomUp(w).visit(s);
        Visitable result = v.visit(this.n0);
        Logger expectedLogger = new Logger();
        expectedLogger.log(new Event(s, this.n0));
        expectedLogger.log(new Event(i, this.n0));
        expectedLogger.log(new Event(i, this.n0));
        WrapLogTest.assertEquals((Object)expectedLogger, (Object)this.logger);
        WrapLogTest.assertEquals((Object)this.n0, (Object)result);
    }

    public WrapLogTest(String test) {
        super(test);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(UtilTest.class);
        return suite;
    }
}

