/*
 * Decompiled with CFR 0.152.
 */
package aterm.test;

import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.pure.PureFactory;

public class TestPrimes {
    private ATermFactory factory;

    void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public static final void main(String[] args) {
        TestPrimes t = new TestPrimes(new PureFactory());
        t.test1();
    }

    public void test1() {
        this.assertTrue(this.getPrimes(30) == this.factory.parse("[1,2,3,5,7,11,13,17,19,23,29]"));
        this.assertTrue(this.getPrimes(500).getLength() == 96);
    }

    public TestPrimes(ATermFactory factory) {
        this.factory = factory;
    }

    public ATermList getPrimes(int max) {
        ATermList primes = this.generateNumbers(max);
        primes = this.filterNonPrimes(primes);
        return primes;
    }

    private ATermList generateNumbers(int max) {
        ATermList numbers = this.factory.makeList();
        int i = max;
        while (i > 0) {
            numbers = this.factory.makeList(this.factory.makeInt(i), numbers);
            --i;
        }
        return numbers;
    }

    private ATermList filterNonPrimes(ATermList numbers) {
        ATermList primes = this.factory.makeList();
        numbers = numbers.getNext();
        while (!numbers.isEmpty()) {
            ATermInt prime = (ATermInt)numbers.getFirst();
            numbers = this.filterMultiples(prime.getInt(), numbers);
            primes = primes.append(prime);
        }
        return this.factory.makeList(this.factory.makeInt(1), primes);
    }

    private ATermList filterMultiples(int n, ATermList numbers) {
        int len = numbers.getLength();
        int i = 0;
        while (i < len) {
            ATermInt el = (ATermInt)numbers.elementAt(i);
            int nr = el.getInt();
            if (nr % n == 0) {
                --len;
                numbers = numbers.removeElementAt(i);
            }
            ++i;
        }
        return numbers;
    }
}

