/*
 * Decompiled with CFR 0.152.
 */
package aterm.test;

import aterm.AFun;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.pure.PureFactory;

public class TestFib {
    private ATermFactory factory;
    private AFun zero;
    private AFun suc;
    private AFun plus;
    private AFun fib;
    private ATermAppl tzero;

    public static final void main(String[] args) {
        TestFib t = new TestFib(new PureFactory());
        t.test1();
        t.test2();
        t.test3(15);
    }

    public TestFib(ATermFactory factory) {
        this.factory = factory;
        this.zero = factory.makeAFun("zero", 0, false);
        this.suc = factory.makeAFun("suc", 1, false);
        this.plus = factory.makeAFun("plus", 2, false);
        this.fib = factory.makeAFun("fib", 1, false);
        this.tzero = factory.makeAppl(this.zero);
    }

    public void test1() {
        this.normalizePlus(this.factory.makeAppl(this.plus, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.tzero)), this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.tzero))));
    }

    public void test2() {
        this.normalizeFib(this.factory.makeAppl(this.fib, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.tzero))))));
    }

    public void test3(int n) {
        ATermAppl N = this.tzero;
        int i = 0;
        while (i < n) {
            N = this.factory.makeAppl(this.suc, N);
            ++i;
        }
        this.normalizeFib(this.factory.makeAppl(this.fib, N));
        System.out.println(this.factory);
    }

    public ATermAppl normalizePlus(ATermAppl t) {
        ATermAppl res = t;
        while (true) {
            ATermAppl v4;
            ATermAppl v3;
            ATermAppl v2;
            ATermAppl v1;
            ATermAppl v0;
            if ((v0 = (ATermAppl)res.getArgument(0)).getAFun() == this.suc && (v1 = (ATermAppl)v0.getArgument(0)).getAFun() == this.suc && (v2 = (ATermAppl)v1.getArgument(0)).getAFun() == this.suc && (v3 = (ATermAppl)v2.getArgument(0)).getAFun() == this.suc && (v4 = (ATermAppl)v3.getArgument(0)).getAFun() == this.suc) {
                res = this.factory.makeAppl(this.plus, v4.getArgument(0), this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, this.factory.makeAppl(this.suc, res.getArgument(1)))))));
                continue;
            }
            if (v0.getAFun() == this.zero) {
                res = (ATermAppl)res.getArgument(1);
                break;
            }
            if (v0.getAFun() != this.suc) break;
            res = this.factory.makeAppl(this.plus, v0.getArgument(0), this.factory.makeAppl(this.suc, res.getArgument(1)));
        }
        return res;
    }

    public ATermAppl normalizeFib(ATermAppl t) {
        ATermAppl v1;
        ATermAppl res = t;
        ATermAppl v0 = (ATermAppl)res.getArgument(0);
        if (v0.getAFun() == this.zero) {
            res = this.factory.makeAppl(this.suc, v0);
        } else if (v0.getAFun() == this.suc && (v1 = (ATermAppl)v0.getArgument(0)).getAFun() == this.zero) {
            res = v0;
        } else if (v0.getAFun() == this.suc && (v1 = (ATermAppl)v0.getArgument(0)).getAFun() == this.suc) {
            ATermAppl v2 = (ATermAppl)v1.getArgument(0);
            ATermAppl fib1 = this.normalizeFib(this.factory.makeAppl(this.fib, v2));
            ATermAppl fib2 = this.normalizeFib(this.factory.makeAppl(this.fib, v1));
            res = this.normalizePlus(this.factory.makeAppl(this.plus, fib1, fib2));
        }
        return res;
    }
}

