/*
 * Decompiled with CFR 0.152.
 */
package aterm.test;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermLong;
import aterm.ATermReal;
import aterm.pure.PureFactory;
import aterm.test.TestFib;
import aterm.test.TestFibInterpreted;
import aterm.test.TestPrimes;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Test1 {
    private ATermFactory factory;

    public static final void main(String[] args) {
        Test1 pureSuite = new Test1(new PureFactory());
        pureSuite.testAll();
    }

    public Test1(ATermFactory factory) {
        this.factory = factory;
    }

    void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    private void test(boolean cond, String id) {
        if (!cond) {
            throw new RuntimeException("test " + id + " failed.");
        }
        System.out.println("\ttest " + id + " ok!");
    }

    public void testMakeInt() {
        ATermInt[] term = new ATermInt[]{this.factory.makeInt(3), this.factory.makeInt(3)};
        this.assertTrue(term[0].getType() == 2);
        this.assertTrue(term[0].getInt() == 3);
        this.assertTrue(term[0] == term[1]);
        this.assertTrue(term[0].toString().equals("3"));
        List<Object> result = term[0].match("3");
        this.assertTrue(result != null && result.size() == 0);
        result = term[0].match("<int>");
        this.assertTrue(result != null && result.size() == 1 && result.get(0).equals(new Integer(3)));
        System.out.println("pass: testMakeInt");
    }

    public void testMakeLong() {
        ATermLong[] term = new ATermLong[]{this.factory.makeLong(3L), this.factory.makeLong(3L)};
        this.assertTrue(term[0].getType() == 8);
        this.assertTrue(term[0].getLong() == 3L);
        this.assertTrue(term[0] == term[1]);
        this.assertTrue(term[0].toString().equals("3"));
        List<Object> result = term[0].match("3L");
        this.assertTrue(result != null && result.size() == 0);
        result = term[0].match("<long>");
        this.assertTrue(result != null && result.size() == 1 && result.get(0).equals(new Long(3L)));
        System.out.println("pass: testMakeLong");
    }

    public void testMakeReal() {
        ATermReal[] term = new ATermReal[]{this.factory.makeReal(Math.PI), this.factory.makeReal(Math.PI)};
        this.assertTrue(term[0].getType() == 3);
        this.assertTrue(term[0].getReal() == Math.PI);
        this.assertTrue(term[0] == term[1]);
        List<Object> result = term[0].match("<real>");
        this.assertTrue(result != null && result.size() == 1 && result.get(0).equals(new Double(Math.PI)));
        System.out.println("pass: testMakeReal");
    }

    public void testMakeAppl() {
        AFun[] symmies = new AFun[4];
        ATermAppl[] apples = new ATermAppl[16];
        symmies[0] = this.factory.makeAFun("f0", 0, false);
        symmies[1] = this.factory.makeAFun("f1", 1, false);
        symmies[2] = this.factory.makeAFun("f6", 6, false);
        symmies[3] = this.factory.makeAFun("f10", 10, false);
        apples[0] = this.factory.makeAppl(symmies[0]);
        apples[1] = this.factory.makeAppl(symmies[1], apples[0]);
        apples[2] = this.factory.makeAppl(symmies[1], apples[1]);
        apples[3] = this.factory.makeAppl(symmies[1], apples[0]);
        apples[4] = this.factory.makeAppl(symmies[2], new ATerm[]{apples[0], apples[0], apples[1], apples[0], apples[0], apples[1]});
        apples[5] = this.factory.makeAppl(symmies[3], new ATerm[]{apples[0], apples[1], apples[0], apples[1], apples[0], apples[1], apples[0], apples[1], apples[0], apples[1]});
        apples[6] = apples[2].setArgument(apples[0], 0);
        this.assertTrue(apples[6].isEqual(apples[1]));
        this.assertTrue(apples[1].isEqual(apples[3]));
        this.assertTrue(!apples[2].isEqual(apples[1]));
        this.assertTrue(!apples[2].isEqual(apples[6]));
        this.assertTrue(!apples[1].isEqual(apples[2]));
        this.assertTrue(!apples[2].isEqual(apples[3]));
        this.assertTrue(!apples[0].isEqual(apples[1]));
        System.out.println("pass: testMakeAppl");
    }

    protected void testParser() {
        ATerm[] T = new ATerm[20];
        int index = 0;
        T[index++] = this.factory.parse("g");
        T[index++] = this.factory.parse("f()");
        T[index++] = this.factory.parse("f(1)");
        T[index++] = this.factory.parse("\"f\"(1)");
        T[index++] = this.factory.parse("\"subject\"(<str>)");
        T[index++] = this.factory.parse("f(1,2,<int>)");
        T[index++] = this.factory.parse("[]");
        T[index++] = this.factory.parse("[1]");
        T[index++] = this.factory.parse("[1,2]");
        T[index++] = this.factory.parse("[1,3.5,4e6,123.21E-3,-12]");
        T[index++] = this.factory.parse("[1,a,f(1)]");
        T[index++] = this.factory.parse("[1,\"a\",f(1), \"g\"(a,\"b\")]");
        int i = 0;
        while (i < index) {
            System.out.println("term " + i + ": " + T[i]);
            ++i;
        }
    }

    protected void testFileParser() {
        try {
            FileInputStream input = new FileInputStream("testFileParser.txt");
            ATerm result = this.factory.readFromTextFile(input);
            input.close();
            System.out.println("result = " + result);
        }
        catch (FileNotFoundException e1) {
            System.out.println(e1);
        }
        catch (IOException e2) {
            System.out.println(e2);
        }
    }

    public void testMakeList() {
        ATerm[] T = new ATerm[10];
        ATermList[] Ts = new ATermList[10];
        T[0] = this.factory.parse("[0,1,2,3,4,5,4,3,2,1]");
        Ts[0] = (ATermList)T[0];
        T[1] = this.factory.parse("[]");
        Ts[1] = this.factory.makeList();
        T[2] = this.factory.parse("[1,2,3]");
        Ts[2] = (ATermList)T[2];
        T[3] = this.factory.parse("[4,5,6]");
        Ts[3] = (ATermList)T[3];
        T[4] = this.factory.parse("[1,2,3,4,5,6]");
        Ts[4] = (ATermList)T[4];
        T[5] = this.factory.parse("[1,2,3,4,5,6,7]");
        Ts[5] = (ATermList)T[5];
        this.test(Ts[0].getLength() == 10, "length-1");
        this.test(Ts[0].indexOf(this.factory.makeInt(2), 0) == 2, "indexOf-1");
        this.test(Ts[0].indexOf(this.factory.makeInt(10), 0) == -1, "indexOf-2");
        this.test(Ts[0].indexOf(this.factory.makeInt(0), 0) == 0, "indexOf-3");
        this.test(Ts[0].indexOf(this.factory.makeInt(5), 0) == 5, "indexOf-4");
        this.test(Ts[0].lastIndexOf(this.factory.makeInt(1), -1) == 9, "lastIndexOf-1");
        this.test(Ts[0].lastIndexOf(this.factory.makeInt(0), -1) == 0, "lastIndexOf-2");
        this.test(Ts[0].lastIndexOf(this.factory.makeInt(10), -1) == -1, "lastIndexOf-3");
        this.test(Ts[2].concat(Ts[3]).equals(Ts[4]), "concat-1");
        this.test(Ts[0].concat(Ts[1]).equals(Ts[0]), "concat-2");
        this.test(Ts[4].append(this.factory.makeInt(7)).equals(Ts[5]), "append-1");
        Ts[7] = Ts[3].insert(this.factory.parse("3"));
        Ts[7] = Ts[7].insert(this.factory.parse("2"));
        Ts[7] = Ts[7].insert(this.factory.parse("1"));
        this.test(Ts[7].equals(Ts[4]), "insert-1");
        this.test(Ts[1].insert(this.factory.parse("1")).equals(this.factory.parse("[1]")), "insert-2");
        this.test(Ts[4].insertAt(this.factory.parse("7"), Ts[4].getLength()).equals(Ts[5]), "insert-3");
        this.test(Ts[5].getPrefix().equals(Ts[4]), "prefix-1");
        this.test(Ts[5].getLast().equals(this.factory.parse("7")), "last-1");
        Ts[8] = this.factory.makeList();
        Ts[9] = (ATermList)Ts[8].setAnnotations(Ts[8].getAnnotations());
        System.out.println("Ts[8].hash = " + Ts[8].hashCode());
        System.out.println("Ts[9].hash = " + Ts[9].hashCode());
        this.test(Ts[8].equals(Ts[9]), "empty-1");
        Ts[8] = this.factory.makeList().getAnnotations();
        Ts[9] = (ATermList)Ts[8].setAnnotations(Ts[8].getAnnotations());
        System.out.println("Ts[8].hash = " + Ts[8].hashCode());
        System.out.println("Ts[9].hash = " + Ts[9].hashCode());
        this.test(Ts[8].equals(Ts[9]), "empty-2");
        System.out.println("pass: testMakeList");
    }

    protected void testPatternMatch() {
        ATerm[] T = new ATerm[10];
        T[0] = this.factory.parse("f(1,2,3)");
        T[1] = this.factory.parse("[1,2,3]");
        T[2] = this.factory.parse("f(a,\"abc\",2.3,<abc>)");
        T[3] = this.factory.parse("f(a,[])");
        this.test(T[0].match("f(1,2,3)") != null, "match-1a");
        List<Object> result = T[1].match("<term>");
        this.test(result != null && result.get(0).equals(T[1]), "match-1b");
        result = T[1].match("[<list>]");
        this.test(result != null && result.get(0).equals(T[1]), "match-1c");
        result = T[1].match("[<int>,<list>]");
        this.test(result != null && result.get(0).equals(new Integer(1)) && result.get(1).equals(this.factory.parse("[2,3]")), "match-1d");
        result = this.factory.parse("f(a)").match("f(<term>)");
        this.test(result != null && result.get(0).equals(this.factory.parse("a")), "match-2a");
        result = this.factory.parse("f(a)").match("<term>");
        this.test(result != null && result.get(0).equals(this.factory.parse("f(a)")), "match-2b");
        result = this.factory.parse("f(a)").match("<fun(<term>)>");
        this.test(result != null && result.get(0).equals("f") && result.get(1).equals(this.factory.parse("a")), "match-2c");
        result = this.factory.parse("a").match("<fun>");
        this.test(result != null && result.get(0).equals("a"), "match-2d");
        result = T[0].match("f(1,<int>,3)");
        this.test(result != null && result.size() == 1 && result.get(0).equals(new Integer(2)), "match-3");
        result = T[2].match("f(<term>,<term>,<real>,<placeholder>)");
        this.test(result != null && result.size() == 4, "match-4a");
        this.test(result != null && result.get(0).equals(this.factory.parse("a")), "match-4b");
        this.test(result != null && result.get(1).equals(this.factory.parse("\"abc\"")), "match-4c");
        this.test(result != null && result.get(2).equals(new Double(2.3)), "match-4d");
        result = T[1].match("[<list>]");
        this.test(result != null && result.size() == 1 && result.get(0).equals(T[1]), "match-6a");
        result = T[1].match("[<int>,<list>]");
        this.test(result != null && result.size() == 2 && result.get(0).equals(new Integer(1)), "match-6b");
        this.test(result != null && result.get(1).equals(this.factory.parse("[2,3]")), "match-6c");
        ATermList empty = this.factory.makeList();
        result = empty.match("[]");
        this.test(result != null && result.size() == 0, "match-6d");
        result = empty.match("[<list>]");
        this.test(result.get(0).equals(this.factory.parse("[]")), "match-6e");
        result = T[0].match("<fun(<int>,<list>)>");
        this.test(result != null && result.size() == 3, "match-7a");
        this.test(result != null && result.get(0).equals("f"), "match-7b");
        this.test(result != null && result.get(1).equals(new Integer(1)), "match-7c");
        this.test(result != null && result.get(2).equals(this.factory.parse("[2,3]")), "match-7d");
        result = T[3].match("f(<term>,[<list>])");
        this.test(result != null && result.size() == 2, "match-8a");
        this.test(result != null && result.get(0).equals(this.factory.parse("a")), "match-8b");
        this.test(result != null && result.get(1) != null, "match-8c");
        this.test(result != null && ((ATermList)result.get(1)).getLength() == 0, "match-8d");
        result = this.factory.parse("fib(suc(suc(suc(suc(suc(suc(suc(suc(suc(suc(zero())))))))))))").match("fib(suc(<term()>))");
        System.out.println("pass: testPatternMatch");
    }

    protected void testPatternMake() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.clear();
        ATerm result = this.factory.make("23", list);
        System.out.println("\tresult = " + result);
        list.clear();
        result = this.factory.make("3.14", list);
        System.out.println("\tresult = " + result);
        list.clear();
        result = this.factory.make("[1,2,3]", list);
        System.out.println("\tresult = " + result);
        list.clear();
        result = this.factory.make("GL(\"toto\")", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(new Integer(1));
        result = this.factory.make("<int>", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(new Double(3.14));
        result = this.factory.make("<real>", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(this.factory.parse("f(a,b,c)"));
        result = this.factory.make("<term>", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(this.factory.parse("f(a,b,c)"));
        list.add(new Integer(3));
        list.add(this.factory.parse("<abc>"));
        result = this.factory.make("[<term>,2,<int>,3.14,<placeholder>]", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(this.factory.parse("b"));
        list.add(new Integer(4));
        result = this.factory.make("f(1,<term>,c,<int>)", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(this.factory.parse("b"));
        list.add(new Integer(4));
        result = this.factory.make("f(1,g(<term>),c,h(<int>))", list);
        System.out.println("\tresult = " + result);
        list.clear();
        list.add(this.factory.parse("1"));
        list.add(this.factory.parse("[]"));
        result = this.factory.make("[<term>,<list>]", list);
        System.out.println("\tresult = " + result);
        this.test(((ATermList)result).getFirst() == this.factory.parse("1"), "make-1a");
        this.test(((ATermList)result).getLength() == 1, "make-1b");
        System.out.println("pass: testPatternMake");
    }

    public void testMaxTerm() {
        int j;
        int idx;
        AFun f = this.factory.makeAFun("f", 1, false);
        AFun a = this.factory.makeAFun("a", 0, false);
        int size = 500;
        ATerm[] array1 = new ATerm[size];
        ATerm[] array2 = new ATerm[size];
        long start = System.currentTimeMillis();
        System.out.println("array1");
        int i = 0;
        while (i < size) {
            if (i % 100 == 0) {
                System.out.print(String.valueOf(i) + "  ");
            }
            idx = i % 10;
            array1[idx] = this.factory.makeAppl(a);
            j = 0;
            while (j < 2 * i) {
                array1[idx] = this.factory.makeAppl(f, array1[idx]);
                ++j;
            }
            ++i;
        }
        System.out.println("\narray2");
        i = 0;
        while (i < size) {
            if (i % 100 == 0) {
                System.out.print(String.valueOf(i) + "  ");
            }
            idx = i % 10;
            array2[idx] = this.factory.makeAppl(a);
            j = 0;
            while (j < 2 * i) {
                array2[idx] = this.factory.makeAppl(f, array2[idx]);
                ++j;
            }
            ++i;
        }
        System.out.println("\ntest");
        i = 0;
        while (i < size) {
            if (i % 500 == 0) {
                System.out.print(String.valueOf(i) + "  ");
            }
            if (array1[idx = i % 10] != array2[idx]) {
                System.out.println("array1[" + idx + "] = " + array1[idx]);
                System.out.println("array2[" + idx + "] = " + array2[idx]);
                throw new RuntimeException("i = " + idx);
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("\ntest " + size + " ok in " + (end - start) + " ms");
        System.out.println(this.factory);
    }

    public void testFib() {
        TestFib t = new TestFib(this.factory);
        t.test1();
        t.test2();
        t.test3(10);
        System.out.println(this.factory.toString());
    }

    public void testPrimes(int n) {
        TestPrimes t = new TestPrimes(this.factory);
        long start = System.currentTimeMillis();
        ATermList l = t.getPrimes(n);
        long end = System.currentTimeMillis();
        System.out.println("primes(" + n + ") in " + (end - start) + " ms");
        System.out.println("#primes(" + n + ") = " + l.getLength());
        System.out.println(this.factory);
    }

    public void testFibInterpreted() {
        TestFibInterpreted t = new TestFibInterpreted(this.factory);
        t.initRules();
        t.test1(12);
        System.out.println(this.factory);
    }

    public void testAll() {
        this.testMakeInt();
        this.testMakeLong();
        this.testMakeReal();
        this.testMakeAppl();
        this.testMakeList();
        this.testPatternMatch();
        this.testPatternMake();
        this.testFib();
        this.testPrimes(2000);
    }
}

