/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure.binary.test;

import aterm.ATerm;
import aterm.pure.PureFactory;
import aterm.pure.binary.BinaryReader;
import aterm.pure.binary.BinaryWriter;
import java.nio.ByteBuffer;
import jjtraveler.VisitFailure;

public class TestBinaryFormat {
    private PureFactory pureFactory = null;

    public TestBinaryFormat() {
        this.setUp();
    }

    public void setUp() {
        this.pureFactory = new PureFactory();
    }

    public void testWriting() throws Exception {
        ATerm input = this.pureFactory.parse("line(box(rect(2), square(4, 3)), circle(6))");
        byte[] expectedResult = new byte[]{1, 2, 4, 108, 105, 110, 101, 1, 2, 3, 98, 111, 120, 1, 1, 4, 114, 101, 99, 116, 2, 2, 1, 2, 6, 115, 113, 117, 97, 114, 101, 2, 4, 2, 3, 1, 1, 6, 99, 105, 114, 99, 108, 101, 2, 6};
        this.write(input, expectedResult);
        input = this.pureFactory.parse("line(line(), line())");
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 4;
        byArray[3] = 108;
        byArray[4] = 105;
        byArray[5] = 110;
        byArray[6] = 101;
        byArray[7] = 1;
        byArray[9] = 4;
        byArray[10] = 108;
        byArray[11] = 105;
        byArray[12] = 110;
        byArray[13] = 101;
        byArray[14] = -128;
        byArray[15] = 1;
        expectedResult = byArray;
        this.write(input, expectedResult);
        input = this.pureFactory.parse("line(line(0), line(1))");
        byte[] byArray2 = new byte[20];
        byArray2[0] = 1;
        byArray2[1] = 2;
        byArray2[2] = 4;
        byArray2[3] = 108;
        byArray2[4] = 105;
        byArray2[5] = 110;
        byArray2[6] = 101;
        byArray2[7] = 1;
        byArray2[8] = 1;
        byArray2[9] = 4;
        byArray2[10] = 108;
        byArray2[11] = 105;
        byArray2[12] = 110;
        byArray2[13] = 101;
        byArray2[14] = 2;
        byArray2[16] = 65;
        byArray2[17] = 1;
        byArray2[18] = 2;
        byArray2[19] = 1;
        expectedResult = byArray2;
        this.write(input, expectedResult);
        input = this.pureFactory.parse("line(10, 11{childAnno}){termAnno{annoOfAnno}}");
        byte[] byArray3 = new byte[53];
        byArray3[0] = 17;
        byArray3[1] = 2;
        byArray3[2] = 4;
        byArray3[3] = 108;
        byArray3[4] = 105;
        byArray3[5] = 110;
        byArray3[6] = 101;
        byArray3[7] = 2;
        byArray3[8] = 10;
        byArray3[9] = 18;
        byArray3[10] = 11;
        byArray3[11] = 4;
        byArray3[12] = 1;
        byArray3[13] = 1;
        byArray3[15] = 9;
        byArray3[16] = 99;
        byArray3[17] = 104;
        byArray3[18] = 105;
        byArray3[19] = 108;
        byArray3[20] = 100;
        byArray3[21] = 65;
        byArray3[22] = 110;
        byArray3[23] = 110;
        byArray3[24] = 111;
        byArray3[25] = 4;
        byArray3[26] = 1;
        byArray3[27] = 17;
        byArray3[29] = 8;
        byArray3[30] = 116;
        byArray3[31] = 101;
        byArray3[32] = 114;
        byArray3[33] = 109;
        byArray3[34] = 65;
        byArray3[35] = 110;
        byArray3[36] = 110;
        byArray3[37] = 111;
        byArray3[38] = 4;
        byArray3[39] = 1;
        byArray3[40] = 1;
        byArray3[42] = 10;
        byArray3[43] = 97;
        byArray3[44] = 110;
        byArray3[45] = 110;
        byArray3[46] = 111;
        byArray3[47] = 79;
        byArray3[48] = 102;
        byArray3[49] = 65;
        byArray3[50] = 110;
        byArray3[51] = 110;
        byArray3[52] = 111;
        expectedResult = byArray3;
        this.write(input, expectedResult);
        input = this.pureFactory.parse("integer(-1)");
        expectedResult = new byte[]{1, 1, 7, 105, 110, 116, 101, 103, 101, 114, 2, -1, -1, -1, -1, 15};
        this.write(input, expectedResult);
        input = this.pureFactory.parse("real(-1.0)");
        byte[] byArray4 = new byte[16];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArray4[2] = 4;
        byArray4[3] = 114;
        byArray4[4] = 101;
        byArray4[5] = 97;
        byArray4[6] = 108;
        byArray4[7] = 3;
        byArray4[14] = -16;
        byArray4[15] = -65;
        expectedResult = byArray4;
        this.write(input, expectedResult);
    }

    public void write(ATerm input, byte[] expectedResult) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(expectedResult.length + 10);
        BinaryWriter bw = new BinaryWriter(input);
        bw.serialize(buffer);
        byte[] result = new byte[buffer.limit()];
        buffer.get(result);
        int expectedResultLength = expectedResult.length;
        int resultLength = result.length;
        if (expectedResultLength != resultLength) {
            TestBinaryFormat.log("The number of written bytes didn't match the number of expected bytes. Was: " + resultLength + ", expected: " + expectedResultLength);
            return;
        }
        int i = 0;
        while (i < resultLength) {
            if (result[i] != expectedResult[i]) {
                TestBinaryFormat.log("Written data didn't match the expected data. Index: " + i + ", was " + result[i] + ", expected " + expectedResult[i]);
                return;
            }
            ++i;
        }
        TestBinaryFormat.log("Writing OK for: " + input);
    }

    public void testReading() {
        byte[] input = new byte[]{1, 2, 4, 108, 105, 110, 101, 1, 2, 3, 98, 111, 120, 1, 1, 4, 114, 101, 99, 116, 2, 2, 1, 2, 6, 115, 113, 117, 97, 114, 101, 2, 4, 2, 3, 1, 1, 6, 99, 105, 114, 99, 108, 101, 2, 6};
        ATerm expectedResult = this.pureFactory.parse("line(box(rect(2), square(4, 3)), circle(6))");
        this.read(input, expectedResult);
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 4;
        byArray[3] = 108;
        byArray[4] = 105;
        byArray[5] = 110;
        byArray[6] = 101;
        byArray[7] = 1;
        byArray[9] = 4;
        byArray[10] = 108;
        byArray[11] = 105;
        byArray[12] = 110;
        byArray[13] = 101;
        byArray[14] = -128;
        byArray[15] = 1;
        input = byArray;
        expectedResult = this.pureFactory.parse("line(line(), line())");
        this.read(input, expectedResult);
        byte[] byArray2 = new byte[20];
        byArray2[0] = 1;
        byArray2[1] = 2;
        byArray2[2] = 4;
        byArray2[3] = 108;
        byArray2[4] = 105;
        byArray2[5] = 110;
        byArray2[6] = 101;
        byArray2[7] = 1;
        byArray2[8] = 1;
        byArray2[9] = 4;
        byArray2[10] = 108;
        byArray2[11] = 105;
        byArray2[12] = 110;
        byArray2[13] = 101;
        byArray2[14] = 2;
        byArray2[16] = 65;
        byArray2[17] = 1;
        byArray2[18] = 2;
        byArray2[19] = 1;
        input = byArray2;
        expectedResult = this.pureFactory.parse("line(line(0), line(1))");
        this.read(input, expectedResult);
        byte[] byArray3 = new byte[53];
        byArray3[0] = 17;
        byArray3[1] = 2;
        byArray3[2] = 4;
        byArray3[3] = 108;
        byArray3[4] = 105;
        byArray3[5] = 110;
        byArray3[6] = 101;
        byArray3[7] = 2;
        byArray3[8] = 10;
        byArray3[9] = 18;
        byArray3[10] = 11;
        byArray3[11] = 4;
        byArray3[12] = 1;
        byArray3[13] = 1;
        byArray3[15] = 9;
        byArray3[16] = 99;
        byArray3[17] = 104;
        byArray3[18] = 105;
        byArray3[19] = 108;
        byArray3[20] = 100;
        byArray3[21] = 65;
        byArray3[22] = 110;
        byArray3[23] = 110;
        byArray3[24] = 111;
        byArray3[25] = 4;
        byArray3[26] = 1;
        byArray3[27] = 17;
        byArray3[29] = 8;
        byArray3[30] = 116;
        byArray3[31] = 101;
        byArray3[32] = 114;
        byArray3[33] = 109;
        byArray3[34] = 65;
        byArray3[35] = 110;
        byArray3[36] = 110;
        byArray3[37] = 111;
        byArray3[38] = 4;
        byArray3[39] = 1;
        byArray3[40] = 1;
        byArray3[42] = 10;
        byArray3[43] = 97;
        byArray3[44] = 110;
        byArray3[45] = 110;
        byArray3[46] = 111;
        byArray3[47] = 79;
        byArray3[48] = 102;
        byArray3[49] = 65;
        byArray3[50] = 110;
        byArray3[51] = 110;
        byArray3[52] = 111;
        input = byArray3;
        expectedResult = this.pureFactory.parse("line(10, 11{childAnno}){termAnno{annoOfAnno}}");
        this.read(input, expectedResult);
        input = new byte[]{1, 1, 7, 105, 110, 116, 101, 103, 101, 114, 2, -1, -1, -1, -1, 15};
        expectedResult = this.pureFactory.parse("integer(-1)");
        this.read(input, expectedResult);
        byte[] byArray4 = new byte[16];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArray4[2] = 4;
        byArray4[3] = 114;
        byArray4[4] = 101;
        byArray4[5] = 97;
        byArray4[6] = 108;
        byArray4[7] = 3;
        byArray4[14] = -16;
        byArray4[15] = -65;
        input = byArray4;
        expectedResult = this.pureFactory.parse("real(-1.0)");
        this.read(input, expectedResult);
    }

    public void read(byte[] input, ATerm expectedResult) {
        ByteBuffer buffer = ByteBuffer.allocate(input.length);
        buffer.put(input);
        buffer.flip();
        BinaryReader binaryReader = new BinaryReader(this.pureFactory);
        binaryReader.deserialize(buffer);
        ATerm result = binaryReader.getRoot();
        if (result != expectedResult) {
            TestBinaryFormat.log("The result didn't match the expected result.");
            return;
        }
        TestBinaryFormat.log("Reading OK for: " + expectedResult);
    }

    public void testChunkification() throws VisitFailure {
        ATerm in = this.makeBigDummyTerm(2500);
        ByteBuffer buffer = ByteBuffer.allocate(1000);
        BinaryWriter bw = new BinaryWriter(in);
        BinaryReader binaryReader = new BinaryReader(this.pureFactory);
        while (!binaryReader.isDone()) {
            buffer.clear();
            bw.serialize(buffer);
            binaryReader.deserialize(buffer);
        }
        ATerm result = binaryReader.getRoot();
        if (result == in) {
            TestBinaryFormat.log("Chunkification OK");
        } else {
            TestBinaryFormat.log("Chunkification FAILED");
        }
    }

    private ATerm makeBigDummyTerm(int x) {
        byte[] b = new byte[x];
        int i = 2;
        while (i < b.length - 1) {
            b[i] = 120;
            ++i;
        }
        b[0] = 97;
        b[1] = 40;
        b[b.length - 1] = 41;
        String s = new String(b);
        return this.pureFactory.parse(s);
    }

    private static void log(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) throws Exception {
        TestBinaryFormat tbf = new TestBinaryFormat();
        tbf.testWriting();
        TestBinaryFormat.log("");
        tbf.testReading();
        TestBinaryFormat.log("");
        tbf.testChunkification();
    }
}

