/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermFwdVoid;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermLong;
import aterm.ATermPlaceholder;
import aterm.ATermReal;
import aterm.pure.PureFactory;
import aterm.stream.BufferedOutputStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import jjtraveler.VisitFailure;

class ATermWriter
extends ATermFwdVoid {
    private static char[] TOBASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private BufferedOutputStreamWriter stream;
    private int position;
    private Map<ATerm, Integer> table;
    private int next_abbrev;

    ATermWriter(OutputStream stream) {
        this.stream = new BufferedOutputStreamWriter(stream);
    }

    public Writer getStream() {
        return this.stream;
    }

    private void emitAbbrev(int abbrev) {
        this.stream.write('#');
        ++this.position;
        StringBuilder buf = new StringBuilder();
        if (abbrev == 0) {
            buf.append(TOBASE64[0]);
        }
        while (abbrev > 0) {
            buf.append(TOBASE64[abbrev % 64]);
            abbrev /= 64;
        }
        String txt = buf.reverse().toString();
        this.stream.write(txt);
        this.position += txt.length();
    }

    public void voidVisitChild(ATerm child) throws VisitFailure {
        int length;
        ATermList annos;
        Integer abbrev;
        if (this.table != null && (abbrev = this.table.get(child)) != null) {
            this.emitAbbrev(abbrev);
            return;
        }
        int start = this.position++;
        if (child.getType() == 4) {
            this.stream.write('[');
        }
        this.visit(child);
        if (child.getType() == 4) {
            this.stream.write(']');
            ++this.position;
        }
        if (!(annos = child.getAnnotations()).isEmpty()) {
            this.stream.write('{');
            ++this.position;
            this.visit(annos);
            this.stream.write('}');
            ++this.position;
        }
        if (this.table != null && (length = this.position - start) > PureFactory.abbrevSize(this.next_abbrev)) {
            Integer key = new Integer(this.next_abbrev++);
            this.table.put(child, key);
        }
    }

    public void voidVisitAppl(ATermAppl appl) throws VisitFailure {
        int nameLength;
        AFun fun = appl.getAFun();
        try {
            nameLength = fun.serialize(this.stream);
        }
        catch (IOException ioex) {
            throw new VisitFailure(ioex.getMessage());
        }
        this.position += nameLength;
        if (fun.getArity() > 0 || nameLength == 0) {
            this.stream.write('(');
            ++this.position;
            int i = 0;
            while (i < fun.getArity()) {
                if (i != 0) {
                    this.stream.write(',');
                    ++this.position;
                }
                this.voidVisitChild(appl.getArgument(i));
                ++i;
            }
            this.stream.write(')');
            ++this.position;
        }
    }

    public void voidVisitList(ATermList list) throws VisitFailure {
        while (!list.isEmpty()) {
            this.voidVisitChild(list.getFirst());
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.stream.write(',');
            ++this.position;
        }
    }

    public void voidVisitPlaceholder(ATermPlaceholder ph) throws VisitFailure {
        this.stream.write('<');
        ++this.position;
        this.voidVisitChild(ph.getPlaceholder());
        this.stream.write('>');
        ++this.position;
    }

    public void voidVisitInt(ATermInt i) {
        String txt = String.valueOf(i.getInt());
        this.stream.write(txt);
        this.position += txt.length();
    }

    public void voidVisitLong(ATermLong i) {
        String txt = String.valueOf(i.getLong());
        this.stream.write(txt);
        this.position += txt.length();
    }

    public void voidVisitReal(ATermReal r) {
        String txt = String.valueOf(r.getReal());
        this.stream.write(txt);
        this.position += txt.length();
    }

    public void voidVisitBlob(ATermBlob blob) {
        String txt = String.valueOf(String.valueOf(blob.getBlobSize())) + '#' + String.valueOf(blob.hashCode());
        this.stream.write(txt);
        this.position += txt.length();
    }

    public void initializeSharing() {
        this.table = new HashMap<ATerm, Integer>();
    }
}

